#httr::set_config(httr::config(ssl_verifypeer = 0L, ssl_verifyhost = 0L))
#Load package library----
lib2load <- c('shiny', 'shinyjs', 'shinyBS', 'shinybusy', 'shinyWidgets', 'leaflet', 'leaflet.extras', 'mapview', 'shiny.i18n',
              'sp', 'sf', 'terra', 'jsonlite', 'geojsonio', 'rmapshaper',
              'plyr', 'dplyr', 'tidyr', 'httr', 'RPostgres', 'DBI', 'pool',
              'reactable', 'formattable', 'plotly', 'ini', 'stringi','digest')
lapply(lib2load, require, c = T)

########
#PART1-LOADING DATA----
d_ <- getSrcDirectory(function(x) {x})
a_ <- read.ini('app.ini')
w_ <- 'www/'
########
#connect to PostgreSQL database
capfish.db <- a_$database$database
capfish.host <- a_$database$host
capfish.db_port <- a_$database$port
capfish.db_user <- a_$database$user
capfish.db_pw <- a_$database$password

conn <- dbConnect(drv=RPostgres::Postgres(),
                  host=capfish.host,
                  port=capfish.db_port ,
                  dbname=capfish.db,
                  user= capfish.db_user ,
                  password=capfish.db_pw)

#connect to local data folder
dir.data <<- getSrcDirectory(function(dummy) {dummy})


  ##load raster data locally
r1 <- terra::rast(paste0(dir.data,"/data/SUIT_cage_total51.tif"))
r2 <- terra::rast(paste0(dir.data,"/data/SUIT_ponds_total51.tif"))
polygon_aqua = geojson_read(paste0(dir.data,"/data/aquapotential.geojson"), what = "sp")
newcrs <- CRS("+proj=longlat +datum=WGS84")
polygon_aqua <- spTransform(polygon_aqua, newcrs)

  #pal <- colorQuantile("RdYlBu", values(r2), n = 7)
pal <- colorNumeric(c("#dddddd",'#cccccc',"#F76915", "#EEDE04","#A0D636", "#2FA236",'#108CC6', "#333ED4", "#11416b"  ), c(0.1, 10, 20, 30, 40,50,60, 70, 100 ), na.color = "transparent")
r_colors <- rgb(t(col2rgb(colors()) / 255))
names(r_colors) <- colors()

  
html_legend_Suitability <- HTML('<br><div><span style="background: linear-gradient(90deg,rgb(219, 219, 219), rgb(204, 204, 204) 11.58%, rgb(247, 106, 23) 24.4467%, rgb(238, 221, 4) 37.3134%, rgb(160, 214, 54) 50.1801%, rgb(47, 162, 54) 63.0468%, rgb(17, 140, 198) 75.9135%, rgb(51, 62, 212) 88.7802%, #11416b); opacity: 0.5; height: 18px; width: 156.44px; display: block; margin-top: 8px;"></span></div>
<div><svg style="width: 172.44px; height:31.5781px;"><g><text x="18.500000000000018" dy="21.578125" dx="0.5ex" text-anchor="end">10</text><line x1="18.500000000000018" x2="18.500000000000018" y1="0" y2="4"  stroke="black" stroke-width="1"></line><text x="38.500000000000014" dy="21.578125" dx="0.5ex" text-anchor="end">20</text><line y1="0" y2="4" x1="38.500000000000014" x2="38.500000000000014" stroke="black" stroke-width="1"></line><text x="58.500000000000014" dy="21.578125" dx="0.5ex" text-anchor="end">30</text><line y1="0" y2="4" x1="58.500000000000014" x2="58.500000000000014" stroke-width="1" stroke="black"></line><text x="78.50000000000001" dy="21.578125" dx="0.5ex" text-anchor="end">40</text><line y1="0" y2="4" x1="78.50000000000001" x2="78.50000000000001" stroke-width="1" stroke="black"></line><text x="98.50000000000001" dy="21.578125" dx="0.5ex" text-anchor="end">50</text><line y1="0" y2="4" x1="98.50000000000001" x2="98.50000000000001" stroke-width="1" stroke="black"></line><text x="118.50000000000001" dy="21.578125" dx="0.5ex" text-anchor="end">60</text><line y1="0" y2="4" x1="118.50000000000001" x2="118.50000000000001" stroke-width="1" stroke="black" ></line><text x="138.50000000000003" dy="21.578125" dx="0.5ex" text-anchor="end">70</text><line y1="0" y2="4" x1="138.50000000000003" x2="138.50000000000003" stroke-width="1" stroke="black" ></line></g></svg></div>
<div><line x1="0" x2="8" y1="18.500000000000018" y2="18.500000000000018" stroke-width="1" stroke="black"></line></div>')  
potentialpal <- colorFactor(c("#FF4041", "#FF6C20","#FFC151","#2D55CC", "#54B848"),c("High probability of aquaculture (farms)", "Medium probability of aquaculture (ponds)", "Low probability of aquaculture (ponds)", "Lake or Reservoir", "Non-aquaculture water bodies"), ordered = TRUE)
html_legend_Aquaculturepondspotential <- HTML('<br><svg width="16" height="16">
  <rect width="16" height="16" style="fill:#FF4041;"/></svg> High probability of aquaculture (farms)<br><svg width="16" height="16">
  <rect width="16" height="16" style="fill:#FF6C20;"/></svg> Medium probability of aquaculture (ponds)<br>
  <svg width="16" height="16"><rect width="16" height="16" style="fill:#FFC151;"/>
  </svg> Low probability of aquaculture(ponds)<br>  <svg width="16" height="16"><rect width="16" height="16" style="fill:#2D55CC;"/>
  </svg> Lake or Reservoir<br> <svg width="16" height="16"><rect width="16" height="16" style="fill:#54B848;"/></svg> Non-aquaculture water bodies<br> ')  

# Creat legend HTML
legend_htmlOut_list1 = tagList()
legend_htmlOut_list2 = tagList()
legend_htmlOut_list3 = tagList()
legend_htmlOut_list1[[1]] = htmlOutput(paste0("legend_Aquaculturepondspotential"), inline=F)
legend_htmlOut_list2[[1]] = htmlOutput(paste0("legend_Aquafarm"), inline=F)
legend_htmlOut_list2[[2]] = htmlOutput(paste0("legend_Earthpond"), inline=F)
legend_htmlOut_list2[[3]] = htmlOutput(paste0("legend_Rivercage"), inline=F)
legend_htmlOut_list3[[1]] = htmlOutput(paste0("legend_SuitabilityRC"), inline=T)
legend_htmlOut_list3[[2]] = htmlOutput(paste0("legend_SuitabilityEP"), inline=T)

clog <- function(x){
  shinyjs::runjs(sprintf('console.log("%s");', x))
}