ui_i18n <- Translator$new(translation_csvs_path = paste0(d_, a_$i18n$path), separator_csv="|")
ui_i18n$set_translation_language(a_$i18n$lang)
#UI DESIGN ----
print('Starting UI...')
ui <- 
tags$link(rel = "stylesheet", type = "text/css", href = "styles.css", useShinyjs(), shiny.i18n::usei18n(ui_i18n),
tags$head(tags$link(rel="shortcut icon", href="CaPFish.ico")),
navbarPage(
  id = "nav",
  position = "fixed-top",
  header = tags$style(type="text/css", "body {padding-top: 1px;}"),
  tags$head(tags$style("#modal .modal-dialog {width: fit-content !important;} body {overflow-y: hidden;}")),
  collapsible = TRUE,
  fluid=TRUE,
#  theme = shinytheme("paper"),
  windowTitle = "the CaPFish Platform", 
  title = tags$div(class = "appname", 
                    p(id = "apptitle","the CaPFish Platform"), 
                    tags$span(id = "subtitle", "the CaPFish Platform Aquaculture Database User Interface"),
                    tags$div(id = "img-id",
                       a(
                         href = 'http://www.fia.gov.kh/',
                         img(
                              src = 'img/FiA_Cambodia.png',
                              title = "Fisheries Administration",
                              height = "45px"
                         )
                       ),
                       a(
                         href = '',
                         img(
                              src = 'img/European_flag.png',
                              title = "EU",
                              height = "45px"
                         )
                       ),
                       a(
                         href = 'https://www.afd.fr/en',
                         img(
                              src = 'img/AFD.png',
                              title = "French Development Agency",
                              height = "45px"
                         )
                       ),
                       a(
                         href = 'https://icem.com.au/',
                         img(
                              src = 'img/icem.png',
                              title = "ICEM – International Centre for Environmental Management Homepage",
                              height = "45px"
                         )
                       ),
                       a(span(
                         tags$button(id='open_login', class="btn action-button", img(id='logged_image', src = "login.png")),
                         tags$button(id='switch_lang', class="btn action-button", img(id='lang_image', src = paste0(ui_i18n$get_translation_language(),'.jpg'), height="20px", width="60px"))
                      ))
                  )
  ), 
  #Home
  tabPanel(ui_i18n$t("ui_nav_page_home"), style = "height: calc(100vh - 70px); overflow-y: scroll;",
              icon = icon("home"), id = "home",
              div(htmlOutput("home_html"))
     ),
  tabPanel("Interactive Data View", style = "height: calc(100vh - 70px); overflow: hidden;",
            tags$div(class = "split-container",
              tags$div(id="interactive-leftPane", class="interactive-frame bg-light",
                       fluidRow(style = 'width :100%; position: relative; left: 15px;',
                         wellPanel(style="background-color:#fff; margin-bottom: 1px;",
                                   tags$div(class = "sectiontitle row", h4(id='prov_sum_title', ui_i18n$t('ui_metric_summary')), span(uiOutput('showProv'), style="width:200px;")),
                                   tags$div(class='row',
                                            column(2,HTML('<img src="img/farm_all.svg">'), p(ui_i18n$t('ui_total_farms')), div(class = 'nummeric_sum',textOutput('farm_count'))),
                                            column(2,HTML('<img src="img/earthponds.svg">'), p(ui_i18n$t('ui_total_earth_ponds')), div(class = 'nummeric_sum',textOutput('ponds_s1'))),
                                            column(2,HTML('<img src="img/earthponds.svg">'), p('Total area of earth ponds (ha) '), div(class = 'nummeric_sum',textOutput('ponds_s2'))),
                                            column(2,HTML('<img src="img/cages.svg">'), p(' Total number of river cages'), div(class = 'nummeric_sum',textOutput( 'cages_s1'))),
                                            column(2,HTML('<img src="img/cages.svg">'), p('Total area of river cages (m\u00B2)'), div(class = 'nummeric_sum',textOutput('cages_s2')))
                                   ))),
                       fluidRow(style = "height: calc(100% - 230px); width :100%; position: relative; left: 15px;",
                       leafletOutput("map", width="100%", height="100%")
              #          tags$div(id= "rightside_btn",class = "leftside-toggle",
              #                   actionBttn("menu_right", label ="", icon ("angle-double-left"),color = "primary")),
              #          absolutePanel(id = "controls_right", 
              #                        class = "cbp-spmenu cbp-spmenu-vertical cbp-spmenu-left", 
              #                        fixed = TRUE,style = "overflow-y: scroll;",
              #                        h3("Layer" , style = "font-weight: 700;font-size: 18px;color: #055a87;"),
              #                        span(tags$i(h6("Aquafarm locations (from field survey)", style = "font-weight: 400;font-size: 14.5px;color: #28b78d;"))),
              #                        uiOutput("sel_year"),
              #                        div(style = "margin-left: 20px", checkboxInput("sel_layer2",label = "Aquafarm",value =  TRUE),
              #                            checkboxInput("sel_layer3",label = "Earth pond",value =  FALSE),
              #                            checkboxInput("sel_layer4",label = "River cage",value =  FALSE)),
              #                        bsTooltip(id = "sel_layer2", title = "Central location of farm (house, office)",placement = "right", trigger = "hover"),
              #                        span(tags$i(h6("Aquaculture ponds map (from remote sensing analysis)", style = "font-weight: 400;font-size: 14.5px;color: #28b78d;"))),
              #                        div(style = "margin-left: 20px",checkboxInput("sel_layer1",label = 'Earth ponds',value = FALSE )),
              #                        span(tags$i(h6("Aquaculture suitability maps (from multi-criteria analysis)", style = "font-weight: 400;font-size: 14.5px;color: #28b78d;"))),
              #                        div(style = "margin-left: 20px",
              #                            checkboxInput("sel_layer5",label = 'Estimated suitability for river cages',value = FALSE ),
              #                            checkboxInput("sel_layer6",label = 'Estimated suitability for earth ponds',value = FALSE )),
              #                        h3('Legend', style = "font-weight: 700;font-size: 18px;color: #055a87;"),
              #                        p('Aquafarm locations (from field survey)'),
              #                        p(legend_htmlOut_list2),
              #                        p(legend_htmlOut_list1),
              #                        p(legend_htmlOut_list3),
              #                        use_busy_bar(color = "#d35e60", height = "10px")
              #          )
              )
              ),
              tags$div(id="interactive-divider", class="divider"),
              tags$div(id="interactive-rightPane", class="interactive-frame bg-white",
                       fluidRow(style = 'width :100%; position: relative; left: 15px;',
                           tabsetPanel(
                             tabPanel(ui_i18n$t('ui_farm_info'), style = 'overflow-x:hidden;',
                                      tags$div(class = "sectiontitle",  h4(ui_i18n$t('ui_graph_summary'))),
                                      br(),
                                      fluidRow(
                                        column(6,
                                               plotlyOutput(
                                                 'farm.labor',
                                                 width = "100%",
                                                 height = "300px",
                                                 inline = FALSE,
                                                 reportTheme = TRUE
                                               )),
                                        column(6,
                                               plotlyOutput(
                                                 'farm.iss',
                                                 width = "100%",
                                                 height = "300px",
                                                 inline = FALSE,
                                                 reportTheme = TRUE
                                               ))),
                                      
                                      
                                      hr(),
                                      fluidRow(
                                        column(6,
                                               plotlyOutput(
                                                 'farm.biz',
                                                 width = "100%",
                                                 height = "300px",
                                                 inline = FALSE,
                                                 reportTheme = TRUE
                                               )),
                                        column(6,
                                               plotlyOutput(
                                                 'farm.tenure',
                                                 width = "100%",
                                                 height = "300px",
                                                 inline = FALSE,
                                                 reportTheme = TRUE
                                               ))
                                      ),
                                      hr(),
                                      fluidRow(
                                        column(6,
                                               plotlyOutput(
                                                 'farm.size',
                                                 width = "100%",
                                                 height = "300px",
                                                 inline = FALSE,
                                                 reportTheme = TRUE
                                               )),
                                        column(6,
                                               plotlyOutput(
                                                 'farm.water',
                                                 width = "100%",
                                                 height = "300px",
                                                 inline = FALSE,
                                                 reportTheme = TRUE
                                               ))
                                      )
                             ),
                             tabPanel(ui_i18n$t('ui_farm_prod'), style = 'overflow-x:hidden;',
                                      tags$div(class = "sectiontitle",  h4('Graphical summaries')),
                                      shinyWidgets::panel(status = "success",
                                                          heading =  selectInput("specie_sum", "Select metric:",
                                                                                 c("Species vs Selling price" = "sp_selp",
                                                                                   "Total yield vs Selling price" = "tp_selp",
                                                                                   "Total yield vs Total area" = "tp_ta",
                                                                                   "Selling price vs Total area" = "selp_ta",
                                                                                   "Total metrics by species" = "sum_tab"
                                                                                 ), selected = "sp_selp"),
                                                          #radioButtons('matrix_option',choices = c('Table', 'Graph'),label = '',selected = 'Graph',inline = TRUE),
                                                          uiOutput("matrix_out")
                                                          #plotlyOutput('species_all')
                                      )
                                      # shinyWidgets::panel(status = "info",
                                      #       heading = selectInput("sel_specie_x",label = p("Select species:"),choices= unique(sort(farm.production$kobo_label_en)), selected = 'Giant Snakehead'),
                                      #       fluidRow(
                                      #         column(style = ("background-color: #e0cae3;color: #333;font-weight: 350;"), 4,textOutput('text1')),
                                      #         column(style = ("background-color: #e8eca2;color: #333;font-weight: 350;"),4,textOutput('text2')),
                                      #         column(style = ("background-color: #cdcfe0;color: #333;font-weight: 350;"),4,textOutput('text3')),
                                      #       ),
                                      #       hr(),
                                      #       fluidRow(formattableOutput('table_farm_issues')),
                                      #       fluidRow(column(3,plotlyOutput('p_price', width = "100%",height = "300px")),
                                      #       column(3,plotlyOutput('p_size', width = "100%",height = "300px")),
                                      #       column(6,plotlyOutput('p_issue', width = "100%",height = "300px"))),
                                      #      
                                      #       hr(),
                                      #       fluidRow(
                                      #       column(6,plotlyOutput('p_fingerling', width = "100%",height = "300px")),
                                      #       column(6,plotlyOutput('p_feed',width = "100%",height = "300px")))
                                      # ),
                                      # shinyWidgets::panel(status = "danger",
                                      #       heading =  selectInput("farm_sum", "Aquafarm metrics:",
                                      #                              c("Farm business" = "fa_buz",
                                      #                                "Farm culture method" = "fa_cul_med",
                                      #                                "Farm technique" = "fa_tech",
                                      #                                "Farm fingerling/juvenile source" = "fa_fin"
                                      #                              )),
                                      #       plotlyOutput('farm_all', width = "100%",height = "300px")
                                      # )
                             ),
                             tabPanel(ui_i18n$t('ui_farm_finance'), style = 'overflow-x:hidden;',
                                      tags$div(class = "sectiontitle",  h4('Graphical summaries')),
                                      fluidRow(
                                        plotlyOutput(
                                          'farm.fin_income2',
                                          width = "100%",
                                          height = "400px",
                                          inline = FALSE,
                                          reportTheme = TRUE
                                        )
                                      ),
                                      hr(),
                                      fluidRow(
                                        plotlyOutput(
                                          'farm.fin_income',
                                          width = "100%",
                                          height = "400px",
                                          inline = FALSE,
                                          reportTheme = TRUE
                                        )
                                      )
                             ),
                             tabPanel(ui_i18n$t('ui_aquafarm_households'), style = 'overflow-x:hidden;',
                                      tags$div(class = "sectiontitle",  h4('Graphical summaries')),
                                      fluidRow(
                                        column(6,
                                               plotlyOutput(
                                                 'farm.hh',
                                                 width = "100%",
                                                 height = "400px",
                                                 inline = FALSE,
                                                 reportTheme = TRUE
                                               )),
                                        column(6,
                                               plotlyOutput(
                                                 'farm.hh.gender',
                                                 width = "100%",
                                                 height = "400px",
                                                 inline = FALSE,
                                                 reportTheme = TRUE
                                               ))  
                                      )
                             )
              ))
   ))
),
   tabPanel(ui_i18n$t('ui_about'), style = "height: calc(100vh - 70px); overflow-y: scroll;", includeHTML('www/about_capfish.html'))),
tags$script(src="capfishjs.js")
)
  

