const minDivSize = 30; // Minimum size in percent for each pane
const divider = document.getElementById("interactive-divider");
const leftPane = document.getElementById("interactive-leftPane");
const rightPane = document.getElementById("interactive-rightPane");

let isDragging = false;

divider.addEventListener("mousedown", function (e) {
    e.preventDefault();
    isDragging = true;
    divider.classList.add("active");
    document.body.style.cursor = "col-resize";
});

document.addEventListener("mousemove", function (e) {
    if (!isDragging) return;

    const container = document.querySelector(".split-container");
    const containerOffsetLeft = container.offsetLeft;
    const pointerRelativeXpos = e.clientX - containerOffsetLeft;
    const containerWidth = container.offsetWidth;

    const leftWidth = (pointerRelativeXpos / containerWidth) * 100;
    const rightWidth = 100 - leftWidth;

    if (leftWidth > minDivSize && rightWidth > minDivSize) { // min 10% width each
    leftPane.style.flex = `0 0 ${leftWidth}%`;
    rightPane.style.flex = `0 0 ${rightWidth}%`;
    }
});

document.addEventListener("mouseup", function () {
    if (isDragging) {
    isDragging = false;
    divider.classList.remove("active");
    document.body.style.cursor = "default";
    }
});